/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpCommon;

import ibm.nways.analysis.dpCommon.NotifyObject;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class PollingObjectInstance
implements Serializable {
    private boolean validNonZeroData = false;
    private String hostname;
    private String podIdentifier;
    private String communityName;
    private NotifyObject whenToNotify;
    private Vector theHistory;
    private Hashtable keywords;
    private long index = -1L;

    public PollingObjectInstance(String string, String string2) {
        this.hostname = string;
        this.podIdentifier = string2;
    }

    public PollingObjectInstance(String string, String string2, String string3) {
        this.hostname = string;
        this.communityName = string2;
        this.podIdentifier = string3;
    }

    public PollingObjectInstance(String string, String string2, String string3, long l) {
        this.hostname = string;
        this.communityName = string2;
        this.podIdentifier = string3;
        this.index = l;
    }

    public PollingObjectInstance(String string, String string2, Vector vector) {
        this.hostname = string;
        this.podIdentifier = string2;
        this.theHistory = vector;
    }

    public PollingObjectInstance(String string, String string2, Vector vector, long l) {
        this.hostname = string;
        this.podIdentifier = string2;
        this.theHistory = vector;
        this.index = l;
    }

    public PollingObjectInstance(PollingObjectInstance pollingObjectInstance) {
        this.podIdentifier = pollingObjectInstance.getIdentifier();
        this.hostname = pollingObjectInstance.getHostname();
        this.communityName = pollingObjectInstance.getCommunityname();
        this.whenToNotify = pollingObjectInstance.getNotifyObject();
        this.theHistory = pollingObjectInstance.getHistory();
        this.index = pollingObjectInstance.getIndex();
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        char[] cArray = this.getHostname().toCharArray();
        int n3 = this.getHostname().length();
        if (n3 < 16) {
            int n4 = n3;
            while (n4 > 0) {
                n = n * 37 + cArray[n2++];
                --n4;
            }
        }
        return n;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public void setKeywords(Hashtable hashtable) {
        this.keywords = hashtable;
    }

    public Hashtable getKeywords() {
        return this.keywords;
    }

    public String getCommunityname() {
        return this.communityName;
    }

    public String getIdentifier() {
        return this.podIdentifier;
    }

    public Vector getHistory() {
        return this.theHistory;
    }

    public void setHistory(Vector vector) {
        this.theHistory = vector;
    }

    public void setNotifyObject(NotifyObject notifyObject) {
        this.whenToNotify = notifyObject;
    }

    public NotifyObject getNotifyObject() {
        return this.whenToNotify;
    }

    public boolean equals(Object object) {
        PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)object;
        return this.getIndex() == pollingObjectInstance.getIndex();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("POI:");
        stringBuffer.append(" Def ID: " + this.podIdentifier);
        stringBuffer.append(",  Host: " + this.hostname);
        if (this.theHistory != null && this.theHistory.size() > 0) {
            stringBuffer.append("\nHistory:");
            int n = 0;
            while (n < this.theHistory.size()) {
                stringBuffer.append(String.valueOf(this.theHistory.elementAt(n).toString()) + "\n");
                ++n;
            }
        }
        if (this.whenToNotify != null) {
            stringBuffer.append("\n" + this.whenToNotify.toString());
        }
        stringBuffer.append("Index is: " + this.index);
        if (this.validNonZeroData) {
            stringBuffer.append("\n The POI has Non-Zero Data");
        } else {
            stringBuffer.append("\n The POI does not have Non-Zero Data");
        }
        return stringBuffer.toString();
    }

    public void setValidNonZeroData(boolean bl) {
        this.validNonZeroData = bl;
    }

    public boolean getValidNonZeroData() {
        return this.validNonZeroData;
    }

    public long getIndex() {
        return this.index;
    }

    public Long getLongIndex() {
        return new Long(this.index);
    }

    public void setIndex(long l) {
        this.index = l;
    }
}

